<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  if (!defined('INDEXU')) {
    include "../application.php";
    include $base_path . "lib/xml.lib.php";
    block_searchfeed($_GET);
  }

  function block_searchfeed($params) {
    global $theme_path, $theme_path, $active_theme;
    
    if ($params['track_id'] == 'xxx' && $params['pub_id'] == 'xxx') {
      return;
    }

    if (strpos($_SERVER['REQUEST_URI'], 'block.searchfeed.php') === FALSE) {
      echo "<script language=\"javascript\" type=\"text/javascript\" src=\"blocks/block.searchfeed.php?".
           "track_id=".$params['track_id'].
           "&amp;pub_id=".$params['pub_id'].
           "&amp;sf_keyword=".urlencode($params['sf_keyword']).
           "&amp;default_keyword=".urlencode($params['default_keyword']).
           "&amp;max_item=".$params['max_item'].
           "&amp;page=".$params['page'].
           "&amp;exclude=".$params['exclude'].
           "\"></script>";
      return;
    }

    $default_keyword = 'make money';

    if (!$params['default_keyword']) {
      $params['default_keyword'] = $default_keyword;
    }

    if (!$params['title']) {
      $params['title'] = 'Our Partners';
    }

    if (!$params['track_id']) {
      $params['track_id'] = '';
    }

    if (!$params['pub_id']) {
      $params['pub_id'] = '';
    }

    if (!$params['sf_keyword']) {
      $params['sf_keyword'] = $params['default_keyword'];
    }
    $params['sf_keyword'] = urlencode($params['sf_keyword']);

    if (!$params['max_item']) {
      $params['max_item'] = '5';
    }

    if (!$params['page']) {
      $params['page'] = '1';
    }

    if (!$params['exclude']) {
      $params['exclude'] = '';
    }

    $ip = $_SERVER['REMOTE_ADDR'];

    $req = "http://www.searchfeed.com/rd/feed/XMLFeed.jsp?".
           "trackID=".$params['track_id'].
           "&pID=".$params['pub_id'].
           "&cat=".$params['sf_keyword'].
           "&nl=".$params['max_item'].
           "&page=".$params['page'].
           "&ip=".$ip.
           "&excID=".$params['exclude'];

    $content = HttpRequest($req);
    $raw = Xml2Array(trim($content['html']));
    $raw = $raw[listing];
    $count_raw = count($raw);

    if ($raw[0]['description'] == 'Invalid Account') {
      return '';
    }
    
    if ($count_raw <= 1 && $params['sf_keyword'] != urlencode($params['default_keyword'])) {
      $req = "http://www.searchfeed.com/rd/feed/XMLFeed.jsp?".
             "trackID=".$params['track_id'].
             "&pID=".$params['pub_id'].
             "&cat=".urlencode($params['default_keyword']).
             "&nl=".$params['max_item'].
             "&page=".$params['page'].
             "&ip=".$ip.
             "&excID=".$params['exclude'];

      $content = HttpRequest($req);
      $raw = Xml2Array(trim($content['html']));
      $raw = $raw[listing];
      $count_raw = count($raw);
    }

    $theme_path = $theme_path . $active_theme . "/";

    $tpl = new Template;

    $tpl->assign('title', $params['title']);
    $i = 0;
    while ($i < $count_raw) {
      $tpl->assign('sf_title', $raw[$i][title]);
      $tpl->assign('sf_url', $raw[$i][url]);
      $tpl->assign('sf_uri', $raw[$i][uri]);
      $tpl->assign('sf_description', $raw[$i][description]);
      $tpl->assign('sf_bid', $raw[$i][bid]);

      $sf_link .= $tpl->fetch('blocks/block.searchfeed_rows.html', 0);
      $i++;
    }
    $tpl->assign('sf_link', $sf_link);
    $content = $tpl->fetch('blocks/block.searchfeed.html', 0);
    $content = explode("\n", $content);

    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");
    header('Content-Type: application/x-javascript');

    while (list(, $v) = @each($content)) {
      $v = str_replace("\n", "", $v);
      $v = str_replace("\r", "", $v);
      $v = str_replace("\t", "", $v);
      echo "document.write(\"".addslashes($v)."\");";
    }
  }


?>
